<?php $__env->startPush('css'); ?>
    <style>
        .table-display tbody tr td {
            position: relative;
        }

        .sub {
            position: absolute;
            top: inherit;
            left: inherit;
            padding: 0 0 0 0;
            list-style-type: none;
            height: 180px;
            overflow: auto;
            z-index: 1;
        }

        .sub li {
            padding: 5px;
            background: #eae9e8;
            cursor: pointer;
            display: block;
            width: 180px;
        }

        .sub li:hover {
            background: #ECF0F5;
        }

        .btn-drag {
            cursor: move;
        }
    </style>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('scripts'); ?>
    <script src="<?php echo e(asset('public/js/admin/module/step2.js')); ?>"></script>
    <script>
        var columns = <?php echo json_encode($columns); ?>;

        function ucwords(str) {
            return (str + '').replace(/^([a-z])|\s+([a-z])/g, function ($1) {
                return $1.toUpperCase();
            });
        }

        function showNameSuggest(t) {
            t = $(t);

            t.next("ul").remove();
            var list = '';
            $.each(columns, function (i, obj) {
                list += "<li>" + obj + "</li>";
            });

            t.after("<ul class='sub'>" + list + "</ul>");
        }

        function showNameSuggestLike(t) {
            t = $(t);

            var v = t.val();
            t.next("ul").remove();
            if (!v) return false;

            var list = '';
            $.each(columns, function (i, obj) {
                if (obj.includes(v.toLowerCase())) {
                    list += "<li>" + obj + "</li>";
                }
            });

            t.after("<ul class='sub'>" + list + "</ul>");
        }

        function showTableField(t) {
            t = $(t);
            var table = t.parent().parent().find('.join_table option:selected').text();
            var v = t.val();

            if ((!table) || (table == 'Input Field Name')) return false;

            t.after("<ul class='sub'><li><i class='fa fa-spin fa-spinner'></i> Loading...</li></ul>");
            $.get("<?php echo e(url('/admin/getJoinFields/')); ?>/" + table, function (response) {
                t.next("ul").remove();
                var list = '';
                $.each(response, function (i, obj) {
                    list += "<li>" + obj + "</li>";
                });
                t.after("<ul class='sub'>" + list + "</ul>");
            });
        }
    </script>
<?php $__env->stopPush(); ?>
<div class="tab-pane active" id="">
    <?php if($errors->any()): ?>
        <div class="alert alert-danger">
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                *<?php echo e($error); ?> <br>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    <?php endif; ?>

    <?php echo e(Form::open(array('url' => 'admin/step2'))); ?>


    <input type="hidden" name="id" value="<?php echo e($id); ?>">

    <table class="table-display table table-striped">
        <thead>
        <tr>
            
            <th>Name</th>
            <th width="90px">Type</th>
            
            
            <th width="90px">Width (px)</th>
            <th width="180px">Action</th>
        </tr>
        </thead>
        <tbody>
        <?php if($module_data != null): ?>
            <?php $__currentLoopData = $module_data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$field): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if($field->inIndex): ?>
                    <tr>
                        
                        <td>
                            <?php echo e(Form::text('name[]', $value = $field->name, $attributes = ['class'=>'name form-control notfocus', 'onclick'=>'showNameSuggest(this)', 'onkeyup'=>'showNameSuggestLike(this)', 'required'])); ?>

                        </td>
                        
                        <td>
                            <?php echo e(Form::select('type[]', [
                                'text' => 'Text',
                                'bool' => 'Bool',
                                'download' => 'Downloadable',
                                'email' => 'Email',
                                'tel' => 'Tel',
                                'secrate' => 'Secrate',
                                'img' => 'Image',
                                'link' => 'Link',
                                'small' => 'Small Text',
                                'medium' => 'Medium Text',
                                'large' => 'Large Text'
                                ], 'text', ['class'=>'form-control type select2', 'required'])); ?>

                        </td>
                        <td>
                            <?php echo e(Form::number('width[]', $value = '10', $attributes = ['class'=>'form-control', 'required'])); ?>

                        </td>
                        <td>
                            <a href="javascript:void(0)" class="btn btn-info btn-plus"><i class="fa fa-plus"></i></a>
                            <a href="javascript:void(0)" class="btn btn-danger btn-delete"><i
                                        class="fa fa-trash"></i></a>
                            <a href="javascript:void(0)" class="btn btn-success btn-up"><i
                                        class="fa fa-arrow-up"></i></a>
                            <a href="javascript:void(0)" class="btn btn-success btn-down"><i
                                        class="fa fa-arrow-down"></i></a>
                        </td>
                    </tr>
                <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php else: ?>
            <?php $__currentLoopData = $tableFields; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$field): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    
                    <td>
                        <?php echo e(Form::text('name[]', $value = $field->getName(), $attributes = ['class'=>'name form-control notfocus', 'onclick'=>'showNameSuggest(this)', 'onkeyup'=>'showNameSuggestLike(this)', 'required'])); ?>

                    </td>
                    
                    <td>
                        <?php echo e(Form::select('type[]', [
                            'text' => 'Text',
                            'bool' => 'Bool',
                            'download' => 'Downloadable',
                            'email' => 'Email',
                            'tel' => 'Tel',
                            'secrate' => 'Secrate',
                            'img' => 'Image',
                            'link' => 'Link',
                            'small' => 'Small Text',
                            'medium' => 'Medium Text',
                            'large' => 'Large Text'
                            ], 'text', ['class'=>'form-control type select2', 'required'])); ?>

                    </td>
                    
                    
                    
                    
                    
                    
                    
                    
                    
                    <td>
                        <?php echo e(Form::number('width[]', $value = '10', $attributes = ['class'=>'form-control', 'required'])); ?>

                    </td>
                    <td>
                        <a href="javascript:void(0)" class="btn btn-info btn-plus"><i class="fa fa-plus"></i></a>
                        <a href="javascript:void(0)" class="btn btn-danger btn-delete"><i class="fa fa-trash"></i></a>
                        <a href="javascript:void(0)" class="btn btn-success btn-up"><i class="fa fa-arrow-up"></i></a>
                        <a href="javascript:void(0)" class="btn btn-success btn-down"><i
                                    class="fa fa-arrow-down"></i></a>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endif; ?>
        <tr id="tr-sample" style="display:none">
            
            <td>
                <?php echo e(Form::text('name[]',
                    $value = null,
                    $attributes = [
                        'class'=> 'name form-control notfocus',
                        'onclick'=> 'showNameSuggest(this)',
                        'onkeyup'=> 'showNameSuggestLike(this)',
                        'placeholder'=> 'Input Field Name',
                        'required']
                    )); ?>

            </td>
            <td>
                <?php echo e(Form::select('type[]', [
                    'text' => 'Text',
                    'bool' => 'Bool',
                    'download' => 'Downloadable',
                    'email' => 'Email',
                    'tel' => 'Tel',
                    'secrate' => 'Secrate',
                    'img' => 'Image',
                    'link' => 'Link',
                    'small' => 'Small Text',
                    'medium' => 'Medium Text',
                    'large' => 'Large Text'
                    ], 'text', ['class'=>'form-control type select2', 'required'])); ?>

            </td>
            <td>
                <?php echo e(Form::number('width[]', $value = '0', $attributes = ['class'=>'form-control', 'required'])); ?>

            </td>
            <td>
                <a href="javascript:void(0)" class="btn btn-info btn-plus"><i class="fa fa-plus"></i></a>
                <a href="javascript:void(0)" class="btn btn-danger btn-delete"><i class="fa fa-trash"></i></a>
                <a href="javascript:void(0)" class="btn btn-success btn-up"><i class="fa fa-arrow-up"></i></a>
                <a href="javascript:void(0)" class="btn btn-success btn-down"><i class="fa fa-arrow-down"></i></a>
            </td>
        </tr>
        </tbody>
    </table>
    <div class="box-footer">
        <?php ($back=url('admin/module/step1/'.$id)); ?>
        <?php echo e(Form::button('Back',['class'=>'btn', 'onclick'=>"window.location='".$back."'"])); ?>

        <?php echo e(Form::submit('Next Step 3',['class'=>'btn btn-primary delete-sample'])); ?>

    </div>
    <?php echo e(Form::close()); ?>

</div><?php /**PATH C:\xampp\htdocs\yamm\resources\views/admin/module/step2.blade.php ENDPATH**/ ?>